<?php

//type_server 1 >>   what 
//type_server 2 >>more
//PASSWORD >>275569


function readJsonFile($filename) {
    if (file_exists($filename)) {
        $data = file_get_contents($filename);
        if ($data === false) {
            http_response_code(500);
            echo json_encode(['status' => 'error', 'message' => 'Error reading the file']);
            exit;
        }
        return json_decode($data, true) ?? [];
    }
    return [];
}

 
function writeJsonFile($filename, $data) {
    if (file_put_contents($filename, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE))) {
        return true;
    }
    return false;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $json = file_get_contents('php://input');
    $data = json_decode($json, true);

    if (!isset($data['what'])) {
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'Request what not specified']);
        exit;
    }

    $type = $data['what'];

    if (($type === 'setting' || $type === 'send_json') && (!isset($data['password']) || $data['password'] !== '275569')) {
        http_response_code(403);
        echo json_encode(['status' => 'error', 'message' => 'Unauthorized access']);
        exit;
    }

    unset($data['password']);

    switch ($type) {
        case 'setting':
           
            $currentData = readJsonFile('data.json');

         
            foreach ($data as $key => $value) {
                if ($key !== 'what') {
                    $currentData[$key] = $value;
                }
            }

    
            if (writeJsonFile('data.json', $currentData)) {
                echo json_encode(['status' => 'success', 'message' => 'Data updated']);
            } else {
                http_response_code(500);
                echo json_encode(['status' => 'error', 'message' => 'Failed to write to data.json']);
            }
            break;

        case 'send_jsons':
            $newJsons = $data['new_jsons'] ?? [];
            if (writeJsonFile('response.json', $newJsons)) {
                echo json_encode(['status' => 'success', 'message' => 'response.json has been replaced']);
            } else {
                http_response_code(500);
                echo json_encode(['status' => 'error', 'message' => 'Failed to write to response.json']);
            }
            break;

        case 'send_json':
       
            $responseData = readJsonFile('response.json');

           
            $newItem = [];
            foreach ($data as $key => $value) {
                if ($key !== 'what') {
                    $newItem[$key] = $value;
                }
            }
            $responseData[] = $newItem;

    
            if (writeJsonFile('response.json', $responseData)) {
                echo json_encode(['status' => 'success', 'message' => 'JSON data saved']);
            } else {
                http_response_code(500);
                echo json_encode(['status' => 'error', 'message' => 'Failed to write to response.json']);
            }
            break;

        case 'send_proxy':
        case 'send_api':
            $file = ($type === 'send_proxy') ? 'proxy.json' : 'api.json';
            $data = readJsonFile($file);
            echo json_encode($data);
            break;

        default:
            http_response_code(400);
            echo json_encode(['status' => 'error', 'message' => 'Invalid request what']);
    }
} elseif ($_SERVER['REQUEST_METHOD'] === 'GET') {
    if (isset($_GET['what'])) {
        $type = $_GET['what'];

        switch ($type) {
            case 'nibio':
            case 'get_proxy':
            case 'get_api':
                $file = ($type === 'nibio') ? 'response.json' : (($type === 'get_proxy') ? 'proxy.json' : 'api.json');
                $data = readJsonFile($file);
                echo json_encode($data);
                break;

            default:
                $file = 'data.json';
                $data = readJsonFile($file);
                echo json_encode($data);
                break;
        }
    } else {
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'type parameter not specified']);
    }
} else {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
}

